import css from "../../services/css.js";
const styles = css `
  eden-toolbar {
    position: sticky;
    top: var(--offset);
    height: calc(var(--action-size) + var(--padding) * 3);
    display: flex;
    align-items: center;
    gap: 2px;
    padding: var(--padding);
    box-sizing: border-box;
    background-color: var(--eden-grey-000);
    box-shadow: var(--eden-shadow-100);
    border: 1px solid var(--eden-grey-100);
    border-radius: var(--eden-radius-200);
    pointer-events: auto;
    will-change: transform;
    animation: eden-toolbar-appearance 160ms var(--eden-transition-easing);
    z-index: -1;
  }

  eden-toolbar:last-child {
    flex: 1 1 100%;
  }

  eden-toolbar:hover {
    z-index: 1;
  }

  eden-toolbar > .option {
    position: relative;
    flex: 0 0 var(--action-size);
    width: var(--action-size);
    height: var(--action-size);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0 2px;
    color: var(--eden-grey-500);
    background-color: transparent;
    border: 0;
    border-radius: var(--eden-radius-200);
    z-index: 1;
    cursor: pointer;
  }

  eden-toolbar > .option:only-of-type {
    padding: 0 3px;
  }

  eden-toolbar > .option:focus {
    outline: none;
  }

  eden-toolbar > .option:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  eden-toolbar > .option:first-of-type {
    z-index: 2;
  }

  eden-toolbar > .option::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    border-radius: inherit;
    background-color: var(--eden-secondary-color);
    opacity: 0;
    transform: scale(0.9);
    transition: opacity 160ms var(--eden-transition-easing),
      transform 160ms var(--eden-transition-easing);
  }

  eden-toolbar > .option .option__icon {
    flex: 0 0 16px;
    width: 16px;
    height: 16px;
    fill: currentcolor;
    transition: fill 160ms var(--eden-transition-easing);
  }

  eden-toolbar > .option:active,
  eden-toolbar > .option--active {
    color: var(--eden-secondary-color);
  }

  eden-toolbar > .option--active::before {
    opacity: 0.2;
    transform: none;
  }

  eden-toolbar > .option[data-dropdown] {
    padding-right: 5px;
  }

  eden-toolbar > .option[data-dropdown]::after {
    content: "";
    position: absolute;
    top: calc(50% - 2px);
    right: 2px;
    padding: 1px;
    border: solid currentcolor;
    border-width: 0 1px 1px 0;
    transform: rotate(45deg);
  }
`;
export default styles;
