var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenToolbar_toggleActive, _EdenToolbar_onSelectionChange;
import styles from "./eden-toolbar.styles.js";
import { findParentFromSelection } from "../../bricks/RichText.js";
class EdenToolbar extends HTMLElement {
    constructor(watchSelectionChange) {
        super();
        this.addButtons = (buttons) => {
            buttons.forEach((button) => {
                button.setAttribute("type", "button");
                this.appendChild(button);
            });
        };
        _EdenToolbar_toggleActive.set(this, (condition, button) => {
            if (condition) {
                button.classList.add("option--active");
            }
            else {
                button.classList.remove("option--active");
            }
        });
        _EdenToolbar_onSelectionChange.set(this, () => {
            this.buttons.forEach((button) => {
                button.classList.remove("option--active");
                const command = button.getAttribute("data-command");
                if (!command)
                    return;
                const dropdownCommands = button.getAttribute("data-dropdown");
                if (dropdownCommands) {
                    const parentSpan = findParentFromSelection("span");
                    if (!parentSpan?.classList)
                        return;
                    const splittedDropdownCommands = dropdownCommands.split(",");
                    const isCommandApplied = splittedDropdownCommands.some((command) => parentSpan.getAttribute("style")?.includes(command) ||
                        parentSpan.classList.contains(command));
                    return __classPrivateFieldGet(this, _EdenToolbar_toggleActive, "f").call(this, isCommandApplied, button);
                }
                if (command === "indent") {
                    const hasBlockquotes = !!findParentFromSelection("blockquote");
                    return __classPrivateFieldGet(this, _EdenToolbar_toggleActive, "f").call(this, hasBlockquotes, button);
                }
                if (command === "link") {
                    const hasLink = !!findParentFromSelection("a");
                    return __classPrivateFieldGet(this, _EdenToolbar_toggleActive, "f").call(this, hasLink, button);
                }
                const isActive = document.queryCommandState(command);
                __classPrivateFieldGet(this, _EdenToolbar_toggleActive, "f").call(this, isActive, button);
            });
        });
        this.watchSelectionChange = watchSelectionChange;
        this.innerHTML = `<style>${styles}</style>`;
    }
    connectedCallback() {
        this.buttons = Array.from(this.querySelectorAll("button"));
        if (this.buttons.length === 0) {
            this.remove();
        }
        if (this.watchSelectionChange) {
            __classPrivateFieldGet(this, _EdenToolbar_onSelectionChange, "f").call(this);
            document.addEventListener("selectionchange", __classPrivateFieldGet(this, _EdenToolbar_onSelectionChange, "f"));
            document.addEventListener("eden-text-formated", __classPrivateFieldGet(this, _EdenToolbar_onSelectionChange, "f"));
        }
    }
    disconnectedCallback() {
        if (this.watchSelectionChange) {
            document.removeEventListener("eden-text-formated", __classPrivateFieldGet(this, _EdenToolbar_onSelectionChange, "f"));
            document.removeEventListener("selectionchange", __classPrivateFieldGet(this, _EdenToolbar_onSelectionChange, "f"));
        }
    }
}
_EdenToolbar_toggleActive = new WeakMap(), _EdenToolbar_onSelectionChange = new WeakMap();
export default EdenToolbar;
if (!customElements.get("eden-toolbar")) {
    customElements.define("eden-toolbar", EdenToolbar);
}
