var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenTextHelper_computePosition;
import template from "./eden-text-helper.template.js";
import styles from "./eden-text-helper.styles.js";
const OFFSET = 3;
class EdenTextHelper extends HTMLElement {
    constructor({ content, tooltip }) {
        super();
        _EdenTextHelper_computePosition.set(this, () => {
            window.requestAnimationFrame(() => {
                const selection = window.getSelection();
                if (!selection || (selection && selection.rangeCount < 1))
                    return;
                const range = selection.getRangeAt(0);
                const { width: helperWidth } = this.getBoundingClientRect();
                const { x, y, height } = range.getBoundingClientRect();
                if (x === 0 && y === 0 && height === 0) {
                    return this.setAttribute("style", "display: none");
                }
                const hasEnoughPlace = x + helperWidth < window.innerWidth - 10;
                const position = hasEnoughPlace ? "right" : "left";
                const otherHelpers = Array.from(document.querySelectorAll("eden-text-helper")).filter((helper) => helper !== this);
                const offsetTop = otherHelpers.reduce((acc, helper) => {
                    const isOnSameDirection = helper.getAttribute("data-position") === position;
                    const isBeforeInDOM = this.compareDocumentPosition(helper) === 4;
                    if (!isOnSameDirection || isBeforeInDOM)
                        return acc;
                    const { height } = helper.getBoundingClientRect();
                    return acc + height + OFFSET;
                }, 0);
                const top = Math.round(window.scrollY + y + height + offsetTop);
                const left = hasEnoughPlace
                    ? Math.round(window.scrollX + x)
                    : Math.round(window.scrollX + x - (helperWidth + OFFSET));
                this.setAttribute("data-position", position);
                this.setAttribute("style", `top: ${top}px; left: ${left}px;`);
            });
        });
        this.update = (content) => {
            this.content = content;
            this.shadowRoot.innerHTML = template(this.content, this.tooltip);
            __classPrivateFieldGet(this, _EdenTextHelper_computePosition, "f").call(this);
        };
        this.init = () => {
            __classPrivateFieldGet(this, _EdenTextHelper_computePosition, "f").call(this);
            document.body.appendChild(this);
        };
        this.content = content;
        this.tooltip = tooltip;
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = template(this.content, this.tooltip);
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    connectedCallback() {
        this.textLengthContainer = this.shadowRoot.querySelector(".text-length");
    }
}
_EdenTextHelper_computePosition = new WeakMap();
export default EdenTextHelper;
if (!customElements.get("eden-text-helper")) {
    customElements.define("eden-text-helper", EdenTextHelper);
}
