import html from "../../services/html.js";
export default function template(dateRanges, hidden) {
    const hiddenDescription = hidden === "true"
        ? html ` <div class="info-ui__hidden">Section cachée</div>`
        : "";
    return html `
    ${dateRanges !== undefined ? renderDateRanges(dateRanges) : ""}
    ${hiddenDescription}
    <div class="info-ui__container"></div>
  `;
}
function renderDateRanges(ranges) {
    const formattedPeriods = ranges
        .map((range) => html ` <div class="info-ui__period">
        du <span class="info-ui__period-date">${range.start}</span> au
        <span class="info-ui__period-date">${range.end}</span>
      </div>`)
        .join("");
    return html `
    <div class="info-ui__dates">
      <div class="info-ui__dates-title">Affiché :</div>
      ${formattedPeriods}
    </div>
  `;
}
