import css from "../../services/css.js";
const styles = css `
  :host {
    display: grid;
    grid-template-columns: repeat(10, 1fr);
    gap: 6px;
  }

  .icon {
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: transparent;
    background-color: transparent;
    padding: 6px;
    border: none;
    border-radius: var(--eden-radius-200);
    cursor: pointer;
    outline: none;
    user-select: none;
    transition: background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .icon:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .icon:not(.icon--current):hover {
    background-color: var(--eden-grey-200);
  }

  .icon:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .icon--current {
    background-color: var(--eden-primary-color);
  }

  .icon > svg {
    width: 24px;
    height: 24px;
    fill: var(--eden-grey-600);
    pointer-events: none;
  }

  .icon--current > svg {
    fill: var(--eden-grey-000);
  }
`;
export default styles;
