var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenIconSelector_updateCurrent;
import template from "./eden-icon-selector.template.js";
import styles from "./eden-icon-selector.styles.js";
class EdenIconSelector extends HTMLElement {
    constructor(mode, sprite, currentId, basePath) {
        super();
        _EdenIconSelector_updateCurrent.set(this, (e) => {
            const target = e.target;
            const icon = target?.closest(".icon");
            if (!target || !icon)
                return;
            const icons = Array.from(this.shadowRoot.querySelectorAll(".icon"));
            icons.forEach((icon) => {
                if (icon === target) {
                    icon.classList.add("icon--current");
                }
                else {
                    icon.classList.remove("icon--current");
                }
            });
            const id = icon.getAttribute("id");
            this.currentId = id;
        });
        this.mode = mode;
        this.sprite = sprite;
        this.currentId = currentId;
        this.basePath = basePath;
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = template(this.mode, this.sprite, this.currentId, this.basePath);
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    connectedCallback() {
        this.shadowRoot.addEventListener("click", __classPrivateFieldGet(this, _EdenIconSelector_updateCurrent, "f"));
    }
    disconnectedCallback() {
        this.shadowRoot.removeEventListener("click", __classPrivateFieldGet(this, _EdenIconSelector_updateCurrent, "f"));
    }
}
_EdenIconSelector_updateCurrent = new WeakMap();
export default EdenIconSelector;
if (!customElements.get("eden-icon-selector")) {
    customElements.define("eden-icon-selector", EdenIconSelector);
}
