var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenDatesSelector_addRange, _EdenDatesSelector_removeRange;
import template, { rangeTemplate } from "./eden-dates-selector.template.js";
import styles from "./eden-dates-selector.styles.js";
class EdenDatesSelector extends HTMLElement {
    constructor(selectedDates) {
        super();
        _EdenDatesSelector_addRange.set(this, () => {
            const range = rangeTemplate();
            this.rangesContainer.append(range);
        });
        _EdenDatesSelector_removeRange.set(this, (e) => {
            const target = e.target;
            const button = target.closest(".remove-range");
            if (!button)
                return;
            const range = target.closest(".range");
            if (!range)
                return;
            range.remove();
        });
        this.getDates = () => {
            const ranges = this.rangesContainer.querySelectorAll(".range");
            const dates = Array.from(ranges)
                .map((range) => {
                const [startInput, endInput] = range.querySelectorAll("eden-input");
                const start = startInput.getAttribute("value");
                const end = endInput.getAttribute("value");
                if (!start || !end)
                    return null;
                return `["${start}","${end}"]`;
            })
                .filter(Boolean)
                .join(",");
            return `[${dates}]`;
        };
        this.updateDates = (dates) => {
            dates.forEach(([copiedStart, copiedEnd]) => {
                const range = rangeTemplate();
                const [start, end] = range.querySelectorAll("eden-input");
                start.setAttribute("value", copiedStart);
                end.setAttribute("value", copiedEnd);
                this.rangesContainer.append(range);
            });
        };
        this.selectedDates = selectedDates;
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = template();
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    connectedCallback() {
        this.rangesContainer = this.shadowRoot.querySelector(".ranges");
        this.addRangeButton = this.shadowRoot.querySelector(".add-range");
        this.updateDates(this.selectedDates);
        this.addRangeButton.addEventListener("click", __classPrivateFieldGet(this, _EdenDatesSelector_addRange, "f"));
        this.rangesContainer.addEventListener("click", __classPrivateFieldGet(this, _EdenDatesSelector_removeRange, "f"));
    }
    disconnectedCallback() {
        this.rangesContainer.removeEventListener("click", __classPrivateFieldGet(this, _EdenDatesSelector_removeRange, "f"));
        this.addRangeButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenDatesSelector_addRange, "f"));
    }
}
_EdenDatesSelector_addRange = new WeakMap(), _EdenDatesSelector_removeRange = new WeakMap();
export default EdenDatesSelector;
if (!customElements.get("eden-dates-selector")) {
    customElements.define("eden-dates-selector", EdenDatesSelector);
}
