import t from "../../i18n/index.js";
import html from "../../services/html.js";
import { generateShortcut } from "../../services/keys.js";
export default function template(canSelectDate) {
    const selectWeekButton = canSelectDate
        ? html `<button
        is="eden-button"
        tabindex="0"
        class="action action--select-weeks"
        tooltip="${t("ui.block-ui.schedule-visibility")}"
      >
        <eden-icon code="calendar" class="action__icon"></eden-icon>
      </button>`
        : "";
    const removeButtonTooltip = `${t("ui.block-ui.remove-block")} ${generateShortcut(t("ui.block-ui.remove-block-short"))}`;
    return html `
    <div class="toolbars"></div>
    <div class="actions">
      <button
        is="eden-button"
        tabindex="0"
        class="action action--move-before"
        tooltip="${t("ui.block-ui.move-block-before")}"
      >
        <eden-icon code="chevron_up" class="action__icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        tabindex="0"
        class="action action--move-after"
        tooltip="${t("ui.block-ui.move-block-after")}"
      >
        <eden-icon code="chevron_down" class="action__icon"></eden-icon>
      </button>
      <div class="action-separator"></div>
      <button
        is="eden-button"
        tabindex="0"
        class="action action--settings"
        tooltip="${t("ui.block-ui.display-block-settings")}"
      >
        <eden-icon code="tune" class="action__icon"></eden-icon>
      </button>
      ${selectWeekButton}
      <button
        is="eden-button"
        tabindex="0"
        class="action action--duplicate"
        tooltip="${t("ui.block-ui.duplicate-block")}"
      >
        <eden-icon code="duplicate" class="action__icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        tabindex="0"
        class="action action--copy"
        tooltip="${t("ui.block-ui.display-block-copy-menu")}"
      >
        <eden-icon code="copy" class="action__icon"></eden-icon>
      </button>
      <div class="action-separator"></div>
      <button
        is="eden-button"
        tabindex="0"
        class="action action--delete"
        tooltip="${removeButtonTooltip}"
      >
        <eden-icon code="delete" class="action__icon"></eden-icon>
      </button>
      <div class="action-separator"></div>
      <button
        is="eden-button"
        tabindex="0"
        class="action action--add-before"
        tooltip="${t("ui.block-ui.add-block-before")}"
      >
        <eden-icon code="add_before" class="action__icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        tabindex="0"
        class="action action--add-after"
        tooltip="${t("ui.block-ui.add-block-after")}"
      >
        <eden-icon code="add_after" class="action__icon"></eden-icon>
      </button>
    </div>
  `;
}
export function obsoleteTemplate() {
    return html `
    <div class="text">
      ${t("ui.block-ui.obsolete-block")}
      <button
        is="eden-button"
        class="info-button"
        tooltip="${t("common.know-more")}"
      >
        <eden-icon code="information" class="action__icon"></eden-icon>
      </button>
    </div>
    <button is="eden-button" class="remove-button">
      ${t("common.remove")}
    </button>
  `;
}
