import css from "../../services/css.js";
import keyShortcutsStyles from "../styles/eden-key-shortcuts-styles.js";
const styles = css `
  :host {
    --action-size: 32px;
    --offset: 4px;
    --padding: 4px;

    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    font-family: var(--eden-content-font);
    font-weight: 400;
    color: var(--eden-grey-500);
    pointer-events: none;
    z-index: 10;
    border-radius: var(--eden-radius-300);
    will-change: opacity;
    animation: block-ui-appearance 160ms var(--eden-transition-easing);
    box-shadow: 0 0 0 calc(1000vh + 100vw) rgba(0, 0, 0, 0.35),
      var(--eden-shadow-300) inset;
    user-select: none;
  }

  @keyframes block-ui-appearance {
    0% {
      opacity: 0;
    }
  }

  .toolbars {
    position: absolute;
    bottom: 0;
    left: var(--offset);
    width: calc(100% - (var(--offset) * 2));
    height: calc(
      100% + var(--action-size) + (var(--padding) * 2) + (var(--offset) * 2)
    );
    display: flex;
    gap: 4px;
    z-index: 11;
    pointer-events: none;
  }

  .actions {
    position: absolute;
    top: calc(100% + var(--offset));
    left: 50%;
    width: calc(100% - (var(--offset) * 2));
    min-width: fit-content;
    height: calc(var(--action-size) + var(--padding) * 3);
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 2px;
    padding: var(--padding);
    box-sizing: border-box;
    background-color: var(--eden-grey-000);
    box-shadow: var(--eden-shadow-100);
    border: 1px solid var(--eden-grey-100);
    border-radius: var(--eden-radius-200);
    pointer-events: auto;
    transform: translateX(-50%);
    z-index: 9;
  }

  .action-separator {
    flex: 0 0 1px;
    width: 1px;
    height: 90%;
    margin: 0;
    background-color: var(--eden-grey-100);
  }

  .action-separator + .action-separator {
    display: none;
  }

  .action {
    position: relative;
    flex: 0 0 var(--action-size);
    width: var(--action-size);
    height: var(--action-size);
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: transparent;
    border: 0;
    border-radius: var(--eden-radius-200);
    cursor: pointer;
    transition: background-color 160ms var(--eden-transition-easing);
  }

  .action[data-selected="true"] {
    background-color: var(--eden-grey-200);
  }

  .action:not(:disabled, [data-selected="true"]):hover {
    background-color: var(--eden-grey-100);
  }

  .action--duplicate {
    margin-left: auto;
  }

  .action--copy {
    padding: 0 8px 0 4px;
  }

  .action--copy::after {
    content: "";
    position: absolute;
    top: calc(50% - 2px);
    right: 5px;
    padding: 1px;
    border: solid var(--eden-grey-600);
    border-width: 0 1px 1px 0;
    transform: rotate(45deg);
  }

  .action:focus {
    outline: none;
  }

  .action:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .action__icon {
    width: 18px;
    height: 18px;
    fill: var(--eden-grey-600);
    transition: fill 160ms var(--eden-transition-easing);
    cursor: pointer;
  }

  .action[data-selected="true"] .action__icon {
    fill: var(--eden-primary-color);
  }

  :disabled {
    filter: opacity(0.5) grayscale(1);
    pointer-events: none;
  }

  ${keyShortcutsStyles()}
`;
export default styles;
export const obsoleteStyles = css `
  :host {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    min-width: 180px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-family: var(--eden-content-font);
    font-weight: 400;
    color: var(--eden-grey-500);
    text-align: center;
    pointer-events: none;
    z-index: 1;
    background-color: rgba(255, 255, 255, 0.65);
    border-radius: var(--eden-radius-100);
    box-shadow: var(--eden-shadow-200);
    will-change: opacity;
    transition: border 320ms var(--eden-transition-easing);
    animation: block-ui-appearance 160ms var(--eden-transition-easing);
    user-select: none;
  }

  @keyframes block-ui-appearance {
    0% {
      opacity: 0;
    }
  }

  :host * {
    pointer-events: auto;
  }

  .text {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 4px;
    font-size: 14px;
    color: var(--eden-grey-000);
    font-weight: 700;
  }

  .info-button {
    position: relative;
    width: 20px;
    height: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    background-color: transparent;
    border: 0;
    border-radius: 50%;
    cursor: pointer;
  }

  .icon {
    width: 18px;
    height: 18px;
    fill: var(--eden-grey-000);
  }

  .remove-button {
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 0 0 7px;
    padding: 10px 15px;
    font-size: 16px;
    text-decoration: none;
    font-weight: 700;
    color: var(--eden-grey-000);
    background: var(--eden-red-gradient);
    border: none;
    border-radius: var(--eden-radius-200);
    user-select: none;
    cursor: pointer;
    transition: background-color 160ms var(--eden-transition-easing);
  }

  .info-button:focus,
  .remove-button:focus {
    outline: none;
  }

  .info-button:focus-visible,
  .remove-button:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }
`;
