import t from "../../i18n/index.js";
import html from "../../services/html.js";
export default function template(categories, hidePaste, authorizedTemplates) {
    return html `
    <div class="backdrop"></div>
    <div class="dropdown">
      ${renderSearch(authorizedTemplates)}
      <div class="columns">
        <div class="column column--categories">
          ${renderPasteButton(hidePaste)} ${renderCategories(categories)}
        </div>
        <div class="column column--templates"></div>
      </div>
    </div>
  `;
}
export const CATEGORY_ICONS = {
    Default: "folder",
    SectionDefault: "grid",
    "Colonne de droite": "sidebar",
    "Right sidebar": "sidebar",
    Textes: "texts",
    Texts: "texts",
    "Boutons & liens": "texts",
    "Buttons & links": "texts",
    Images: "image",
    "Images & Vidéos": "image",
    "Images & Videos": "image",
    Bandeaux: "image",
    Banners: "image",
    "Bandeaux et entêtes": "image",
    "Banners & headers": "image",
    "Textes & images": "text_images",
    "Texts & images": "text_images",
    Multimedia: "text_images",
    Vidéos: "videos",
    Videos: "videos",
    Cartes: "map",
    Maps: "map",
    "Mises en avant": "offers",
    Highlights: "offers",
    "Templates avancés": "advanced",
    "Advanced templates": "advanced",
    Divers: "advanced",
    Miscellaneous: "advanced",
    Utilitaires: "advanced",
    Utilities: "advanced",
    "Espaces et séparateur": "spacers",
    "Spaces & separators": "spacers",
    "Pied de page": "footer",
    Footer: "footer",
    "Offres produits": "products",
    "Product offers": "products",
    Tableaux: "tables",
    Tables: "tables",
};
function renderCategories(categories) {
    return Object.keys(categories)
        .map((category) => {
        const code = CATEGORY_ICONS[category] || CATEGORY_ICONS.Default;
        return html `
        <button class="category">
          <span class="category__icon"
            ><eden-icon code="${code}"></eden-icon
          ></span>
          ${category}
          <eden-icon code="chevron_right" class="category__chevron"></eden-icon>
        </button>
      `;
    })
        .join("");
}
function renderPasteButton(hidePaste) {
    if (hidePaste)
        return "";
    return html `
    <button class="clipboard-item">
      <span class="clipboard-item__icon"
        ><eden-icon code="copy"></eden-icon
      ></span>
      ${t("ui.clipboard.paste")}
    </button>
  `;
}
function renderSearch(authorizedTemplates) {
    if (authorizedTemplates)
        return "";
    return html `
    <div class="search">
      <div class="search__top">
        <eden-icon code="add_block_search" class="search__icon"></eden-icon>
        <eden-input
          class="search__input"
          type="text"
          name="search"
          placeholder="${t("ui.add-block.search")}"
          autocomplete="off"
        ></eden-input>
        <button class="search__button">
          <eden-icon code="close"></eden-icon>
        </button>
      </div>
      <div class="search__results">
        <div class="search__results-inner"></div>
      </div>
    </div>
  `;
}
