import css from "../../services/css.js";
const styles = css `
  :host {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    color: var(--eden-grey-500);
    font-family: var(--eden-content-font);
    font-weight: 400;
    z-index: 840;
  }

  .backdrop {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.2);
    z-index: 0;
    transition: opacity 160ms var(--eden-transition-easing);
    animation: backdrop-appearance 160ms var(--eden-transition-easing);
  }

  @keyframes backdrop-appearance {
    0% {
      opacity: 0;
    }
  }

  :host([closing]) .backdrop {
    opacity: 0;
  }

  .dropdown {
    position: absolute;
    width: 360px;
    max-width: 100%;
    height: 810px;
    max-height: calc(100vh / 2);
    display: flex;
    flex-direction: column;
    background-color: var(--eden-grey-000);
    box-shadow: var(--eden-shadow-100);
    border: 1px solid var(--eden-grey-100);
    border-radius: var(--eden-radius-200);
    z-index: 1;
    overflow: hidden;
    transition: opacity 240ms var(--eden-transition-easing),
      transform 240ms var(--eden-transition-easing);
    animation: add-section-appearance 240ms var(--eden-transition-easing);
  }

  @media (max-width: 600px) {
    .dropdown {
      top: 50% !important;
      left: 50% !important;
      width: 320px;
      max-width: 96vw;
      transform: translate(-50%, -50%) !important;
    }
  }

  :host([closing]) .dropdown {
    opacity: 0;
    transform: scale(0.95);
    transform-origin: center center !important;
  }

  @keyframes add-section-appearance {
    0% {
      opacity: 0;
      transform: scale(0.95);
    }
  }

  .search {
    width: 100%;
    display: flex;
    flex-direction: column;
    padding: 6px;
    box-sizing: border-box;
    background: var(--eden-grey-gradient);
    border-bottom: 1px solid;
    border-image: linear-gradient(
        to right,
        var(--eden-grey-200) 0%,
        var(--eden-grey-100) 100%
      )
      1;
    z-index: 2;
  }

  .search__top {
    position: relative;
    display: flex;
    align-items: center;
    padding: 4px;
    box-sizing: border-box;
    z-index: 1;
  }

  .search__icon {
    position: absolute;
    left: 12px;
    width: 24px;
    height: 24px;
    fill: var(--eden-grey-500);
    pointer-events: none;
    z-index: 1;
  }

  .search__input {
    max-width: 100%;
    margin: 0;
  }

  .search__input .eden-input__input {
    padding: 8px 8px 8px 36px;
  }

  .search__button {
    position: absolute;
    right: 8px;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-left: auto;
    padding: 0;
    background-color: transparent;
    border: 0;
    border-radius: var(--eden-radius-100);
    cursor: pointer;
    user-select: none;
    box-shadow: 0 0 0 1px transparent inset;
    opacity: 0;
    pointer-events: none;
    transition: opacity 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .search--opened .search__button {
    opacity: 1;
    pointer-events: auto;
  }

  .search__button:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .search__button:hover {
    background-color: var(--eden-grey-100);
  }

  .search__button:focus {
    outline: none;
  }

  .search__button:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .search__button > eden-icon {
    width: 16px;
    height: 16px;
    fill: var(--eden-grey-500, #f5f5f5);
  }

  .search__results {
    display: none;
  }

  .search--opened .search__results {
    --offset: 55px;

    position: absolute;
    top: var(--offset);
    left: 0;
    width: 100%;
    height: calc(100% - var(--offset));
    display: block;
    background-color: var(--eden-grey-000);
    border-top: 1px solid var(--eden-grey-100);
    z-index: 0;
    animation: add-section-search-appearance 320ms var(--eden-transition-easing);
  }

  @keyframes add-section-search-appearance {
    0% {
      opacity: 0;
    }
  }

  .search__results-inner {
    flex: 0 0 100%;
    height: 100%;
    display: flex;
    flex-direction: column;
    padding: 10px;
    box-sizing: border-box;
    overflow: auto;
    scrollbar-width: thin;
    overscroll-behavior: contain;
    background: linear-gradient(var(--eden-grey-000) 30%, hsla(0, 0%, 100%, 0)),
      linear-gradient(hsla(0, 0%, 100%, 0), var(--eden-grey-000) 70%) 0 100%,
      radial-gradient(farthest-side at 50% 0, rgba(0, 0, 0, 0.2), transparent),
      radial-gradient(
          farthest-side at 50% 100%,
          rgba(0, 0, 0, 0.2),
          transparent
        )
        0 100%;
    background-repeat: no-repeat;
    background-size: 100% 40px, 100% 40px, 100% 14px, 100% 14px;
    background-attachment: local, local, scroll, scroll;
    transition: transform 320ms var(--eden-transition-easing);
  }

  .search__no-results {
    padding: 15px;
    color: var(--eden-grey-300);
    font-size: 15px;
    font-style: italic;
    text-align: center;
  }

  .columns {
    position: relative;
    height: 100%;
    display: flex;
    padding: 0 0 0 5px;
    box-sizing: border-box;
    overflow: hidden;
    z-index: 1;
  }

  .column {
    flex: 0 0 100%;
    height: calc(100% + 1px);
    display: flex;
    flex-direction: column;
    padding: 10px 10px 10px 5px;
    box-sizing: border-box;
    overflow: auto;
    scrollbar-width: thin;
    overscroll-behavior: contain;
    background: linear-gradient(var(--eden-grey-000) 30%, hsla(0, 0%, 100%, 0)),
      linear-gradient(hsla(0, 0%, 100%, 0), var(--eden-grey-000) 70%) 0 100%,
      radial-gradient(farthest-side at 50% 0, rgba(0, 0, 0, 0.2), transparent),
      radial-gradient(
          farthest-side at 50% 100%,
          rgba(0, 0, 0, 0.2),
          transparent
        )
        0 100%;
    background-repeat: no-repeat;
    background-size: 100% 40px, 100% 40px, 100% 14px, 100% 14px;
    background-attachment: local, local, scroll, scroll;
    transition: transform 160ms var(--eden-transition-easing);
  }

  .clipboard-item {
    padding: 15px 15px 15px 10px;
    border-bottom: 1px solid var(--eden-grey-300);
  }

  .clipboard-item,
  .category,
  .template,
  .template-variants__variant {
    flex: 0 0 auto;
    min-height: 50px;
    position: relative;
    display: flex;
    align-items: center;
    gap: 10px;
    color: var(--eden-grey-500);
    text-align: left;
    font-family: inherit;
    font-size: 15px;
    background-color: transparent;
    border-radius: var(--eden-radius-200);
    border: 0;
    user-select: none;
    cursor: pointer;
    box-shadow: 0 0 0 1px transparent inset;
    transition: color 160ms var(--eden-transition-easing),
      background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .category {
    padding: 10px 30px 10px 10px;
  }

  .clipboard-item:hover,
  .category:hover,
  .template:hover,
  .template-variants__variant:hover {
    background-color: var(--eden-grey-100);
  }

  .clipboard-item:focus,
  .category:focus,
  .template:focus,
  .template-variants__variant:focus,
  button.category-title:focus {
    outline: none;
  }

  .clipboard-item:focus-visible,
  .category:focus-visible,
  .template:focus-visible,
  .template-variants__variant:focus-visible,
  button.category-title:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .clipboard-item:active,
  .category:active,
  .template:active,
  .template-variants__variant:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .category__chevron {
    position: absolute;
    top: 50%;
    right: 10px;
    width: 16px;
    height: 16px;
    fill: currentcolor;
    transform: translateY(-50%);
  }

  .clipboard-item__icon,
  .category__icon {
    position: relative;
    flex: 0 0 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: var(--eden-primary-color-o-20);
    border: 1px solid var(--eden-primary-color);
    border-radius: var(--eden-radius-200);
  }

  .clipboard-item__icon > eden-icon,
  .category__icon > eden-icon {
    width: 16px;
    height: 16px;
    fill: var(--eden-secondary-color);
  }

  .clipboard-item__icon > eden-icon svg,
  .category__icon > eden-icon svg {
    display: block;
  }

  .template {
    padding: 10px;
    box-sizing: border-box;
  }

  .template__inner {
    flex: 1 1 100%;
    display: flex;
    flex-direction: column;
  }

  .template__name {
    display: flex;
    align-items: center;
    gap: 10px;
  }

  .template__name-inner {
    display: flex;
    flex-direction: column;
  }

  .template__category {
    font-size: 11px;
    text-transform: uppercase;
  }

  .template__icon {
    flex: 0 0 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: var(--eden-grey-100);
    border: 1px solid var(--eden-grey-200);
    border-radius: var(--eden-radius-200);
    transition: backgroun-color 160ms var(--eden-transition-easing);
  }

  .template:hover .template__icon {
    background-color: var(--eden-grey-000);
  }

  .template__icon > eden-icon {
    width: 16px;
    height: 16px;
    fill: currentcolor;
  }

  .template__icon > eden-icon svg {
    display: block;
  }

  .template__warning {
    margin-top: 3px;
    color: var(--eden-red-400);
    font-style: italic;
    font-size: 11px;
  }

  .template__button {
    position: relative;
    flex: 0 0 24px;
    width: 24px;
    height: 24px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    font-family: inherit;
    background-color: var(--eden-grey-100);
    border: 0;
    cursor: pointer;
    box-sizing: border-box;
    box-shadow: 0 0 0 1px transparent inset;
    outline: none;
    border-radius: var(--eden-radius-100);
    transition: background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .template:hover .template__button:not(:hover) {
    background-color: var(--eden-grey-000);
  }

  .template:hover .template__button:first-of-type {
    margin-left: auto;
  }

  .template__button:not(:last-child) {
    margin-right: 8px;
  }

  .template__button:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .template__button:hover {
    background-color: var(--eden-grey-300);
  }

  .template__button-icon {
    width: 16px;
    height: 16px;
    fill: var(--eden-grey-500);
    pointer-events: none;
    transition: transform 160ms var(--eden-transition-easing);
  }

  .template__button--open .template__button-icon {
    transform: scale(1, -1);
  }

  .template-variants {
    display: none;
    flex-direction: column;
    border-radius: var(--eden-radius-100);
  }

  .template-variants--opened {
    display: flex;
    animation: template-variants-opening 160ms var(--eden-transition-easing);
  }

  @keyframes template-variants-opening {
    0% {
      opacity: 0;
      transform: translateY(-6px);
    }
  }

  .template-variants__variant {
    flex: 0 0 auto;
    height: auto;
    padding: 6px 10px;
  }

  .template-variants__variant-icon {
    flex: 0 0 16px;
    width: 16px;
    height: 16px;
    fill: currentcolor;
  }

  .category-title {
    width: fit-content;
    min-height: 30px;
    display: flex;
    align-items: center;
    gap: 4px;
    margin-bottom: 10px;
    padding: 8px 10px 8px 6px;
    font-size: 16px;
    font-family: inherit;
    line-height: 1;
    font-weight: 700;
    text-align: left;
    color: var(--eden-grey-500);
    background-color: transparent;
    border: 0;
    box-shadow: 0 0 0 1px transparent inset;
    border-radius: var(--eden-radius-200);
    transition: box-shadow 160ms var(--eden-transition-easing);
  }

  button.category-title:is(:hover, :focus) {
    background-color: var(--eden-grey-100);
    cursor: pointer;
  }

  button.category-title:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .category-title__go-back {
    flex: 0 0 14px;
    width: 14px;
    height: 14px;
    fill: currentcolor;
  }
`;
export default styles;
