import EdenAddBlockPreview from "./eden-add-block-preview.js";
import { GroupedTemplates } from "../../types.js";
import type EdenInput from "../common/eden-input.js";
type Event = MouseEvent;
interface Callbacks {
    addBlock: (code: string, variant?: string) => void;
    paste: () => void;
}
type Templates = string[] | undefined;
type HidePaste = boolean | undefined;
export default class EdenAddBlock extends HTMLElement {
    #private;
    event: Event;
    callbacks: Callbacks;
    authorizedTemplates: Templates;
    descriptionContainer: EdenAddBlockPreview | undefined;
    templates: GroupedTemplates;
    shadowRoot: ShadowRoot;
    elementWidth: number;
    elementHeight: number;
    leftPosition: number;
    currentCategory: string | null;
    closing: boolean;
    dropdown: HTMLElement;
    backdrop: HTMLElement;
    search: HTMLElement;
    searchButton: HTMLElement;
    searchInput: EdenInput;
    searchResults: HTMLElement;
    templatesList: HTMLElement;
    categoriesList: HTMLElement;
    categories: HTMLElement[];
    columns: HTMLElement[];
    clipboardButton: HTMLElement;
    constructor(event: Event, callbacks: Callbacks, authorizedTemplates: Templates, hidePaste: HidePaste);
    connectedCallback(): void;
    disconnectedCallback(): void;
}
export {};
//# sourceMappingURL=eden-add-block.d.ts.map