import css from "../../services/css.js";
const SCALING = 0.7;
export default function styles({ top, bottom, left, right }) {
    const anchorDistanceFromRight = window.innerWidth - left;
    const anchorDistanceFromBottom = window.innerHeight - bottom;
    return css `
    eden-add-block-preview {
      position: fixed;
      width: auto;
      max-width: ${right / SCALING}px;
      display: flex;
      flex-direction: column;
      gap: 8px;
      padding: 15px;
      font-family: var(--eden-content-font);
      font-weight: 400;
      font-size: 14px;
      background-color: #ffffff;
      border-radius: var(--eden-radius-200);
      box-shadow: var(--eden-shadow-200);
      pointer-events: none;
      opacity: 1;
      transform: scale(${SCALING});
      transition: opacity 320ms var(--eden-transition-easing);
      overflow: hidden;
      z-index: 841;
    }

    eden-add-block-preview[x-anchor="left"] {
      max-width: ${left / SCALING}px;
      right: ${anchorDistanceFromRight + 10}px;
    }

    eden-add-block-preview[x-anchor="right"] {
      left: ${right + 10}px;
    }

    eden-add-block-preview[y-anchor="top"] {
      top: ${top}px;
    }

    eden-add-block-preview[y-anchor="bottom"] {
      bottom: ${anchorDistanceFromBottom}px;
    }

    eden-add-block-preview[x-anchor="left"][y-anchor="top"] {
      transform-origin: right top;
    }

    eden-add-block-preview[x-anchor="left"][y-anchor="bottom"] {
      transform-origin: right bottom;
    }

    eden-add-block-preview[x-anchor="right"][y-anchor="top"] {
      transform-origin: left top;
    }

    eden-add-block-preview[x-anchor="right"][y-anchor="bottom"] {
      transform-origin: left bottom;
    }

    .eden-description-inner {
      max-width: 400px;
      font-size: 20px;
    }

    .eden-description-inner::before,
    .eden-description-preview::before {
      width: max-content;
      display: block;
      margin-bottom: 7px;
      padding: 6px 10px;
      background-color: var(--eden-primary-color);
      color: var(--eden-grey-000);
      letter-spacing: 1px;
      font-size: 17px;
      text-transform: uppercase;
      font-weight: 400;
      border-radius: calc(var(--eden-radius-100) * 2);
    }

    .eden-description-inner:not(:empty)::before {
      content: var(--eden-label-description, "Description");
    }

    .eden-description-preview:not(:empty)::before {
      content: var(--eden-label-preview, "Aperçu");
    }

    .eden-description-inner img {
      width: 100%;
      max-width: 340px;
    }

    .eden-description-preview section img {
      max-width: 100%;
      height: auto;
      max-height: 300px;
    }
  `;
}
