import html from "../../services/html.js";
import styles from "./eden-add-block-preview.styles.js";
export default class EdenAddBlockPreview extends HTMLElement {
    constructor(anchors, content) {
        super();
        this.anchors = anchors;
        this.innerHTML = html `<style>
        ${styles(this.anchors)}
      </style>
      ${content}`;
    }
    connectedCallback() {
        const { top, right } = this.anchors;
        const hasEnoughSpaceOnRight = right + this.clientWidth < window.innerWidth;
        const hasEnoughSpaceOnBottom = top + this.clientHeight < window.innerHeight;
        const anchorX = hasEnoughSpaceOnRight ? "right" : "left";
        const anchorY = hasEnoughSpaceOnBottom ? "top" : "bottom";
        this.setAttribute("x-anchor", anchorX);
        this.setAttribute("y-anchor", anchorY);
    }
    disconnectedCallback() { }
}
if (!customElements.get("eden-add-block-preview")) {
    customElements.define("eden-add-block-preview", EdenAddBlockPreview);
}
