export function normalize(text) {
    if ("normalize" in String.prototype &&
        String.prototype.normalize.length === 0) {
        return text.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
    }
    return text;
}
export function slugify(text) {
    return normalize(text.toString())
        .toLowerCase()
        .trim()
        .replace(/\s+/g, "-")
        .replace(/[^\w-]+/g, "")
        .replace(/--+/g, "-");
}
