import html from "./html.js";
const AVERAGE_LENGTH_WORD = 5;
const IGNORED_KEYS = [
    "Backspace",
    "Delete",
    "ArrowLeft",
    "ArrowRight",
    "ArrowUp",
    "ArrowDown",
    "Home",
    "End",
    "Tab",
    "Enter",
    "Shift",
    "Control",
    "Alt",
    "Meta",
    "CapsLock",
    "Escape",
    "PageUp",
    "PageDown",
    "Insert",
    "F1",
    "F2",
    "F3",
    "F4",
    "F5",
    "F6",
    "F7",
    "F8",
    "F9",
    "F10",
    "F11",
    "F12",
    "NumLock",
    "ScrollLock",
    "Pause",
];
export function getTextLengthHerlperContent(element, options) {
    if (!options?.textLength)
        return;
    const textLength = element?.textContent?.length || 0;
    const { max } = options.textLength;
    const content = html `<span>${textLength}</span>/<span>${max}</span>`;
    const optimalWordsLength = Math.round(max / AVERAGE_LENGTH_WORD);
    const tooltip = `La longueur optimale de ce texte est d'environ ${optimalWordsLength} mots`;
    return { content, tooltip };
}
export function updateErrorAttribute(element, helper, options) {
    if (!helper || !options?.textLength)
        return;
    const textLength = element?.textContent?.length || 0;
    const { max } = options.textLength;
    if (textLength >= max) {
        helper.setAttribute("error", "");
    }
    else {
        helper.removeAttribute("error");
    }
}
export function preventDefaultIfNecessary(event, enforceTextLength, element, options) {
    if (!options?.textLength)
        return;
    const textLength = element?.textContent?.length || 0;
    const { max } = options.textLength;
    if (enforceTextLength && textLength > max) {
        if (!IGNORED_KEYS.includes(event.key)) {
            return event.preventDefault();
        }
    }
}
