function updateCursorPosition(event) {
    if (window.Eden.players.length === 0)
        return;
    const pageHeight = document.documentElement.scrollHeight;
    const cursorY = event.pageY;
    window.Eden.cursorPosition = Math.round((cursorY / pageHeight) * 100);
}
const debouncedUpdateCursorPosition = (() => {
    let timeoutId;
    return (event) => {
        if (timeoutId) {
            clearTimeout(timeoutId);
        }
        timeoutId = window.setTimeout(() => {
            updateCursorPosition(event);
        }, 100);
    };
})();
export function trackCursorPosition() {
    document.addEventListener("mousemove", debouncedUpdateCursorPosition, {
        passive: true,
    });
}
