import { fetchNodeUpdate, fetchNodeCreation, fetchNodeMove, fetchNodeRename, fetchNodeRemoval } from "./fetcher.js";
import type { NodeAction } from "../types.js";
declare const actions: {
    saveNode: typeof fetchNodeUpdate;
    create: typeof fetchNodeCreation;
    move: typeof fetchNodeMove;
    rename: typeof fetchNodeRename;
    remove: typeof fetchNodeRemoval;
};
export declare function saveNavContent(action: keyof typeof actions, node: NodeAction): Promise<any>;
interface SaveZonesParams {
    lang: string;
    path: string;
    startedAt?: number;
    ignoreFixedZones?: boolean;
}
export declare function saveZones({ lang, path, startedAt, ignoreFixedZones, }: SaveZonesParams): Promise<{
    error: any;
    status?: undefined;
} | {
    status: string;
    error?: undefined;
}>;
export declare function checkLastUpdated(path: string): Promise<any>;
export declare function getTimestamp(): Promise<any>;
export declare function getFilesList(path: string): Promise<any>;
export declare function getFilesStorageStats(): Promise<any>;
export declare function createFolder(name: string, path: string): Promise<any>;
export declare function removeItem(path: string, paths: string[]): Promise<any>;
export declare function renameItem(file: string, name: string): Promise<any>;
export declare function cropItem(path: string, left: number, top: number, width: number, height: number, targetWidth: number, targetHeight: number, only?: unknown): Promise<any>;
export declare function moveList(paths: string[]): Promise<any>;
export declare function moveItem(path: string, paths: string[], target: string): Promise<any>;
export declare function rotateImage(path: string): Promise<any>;
export declare function uploadItem(payload: FormData): Promise<any>;
export {};
//# sourceMappingURL=api.d.ts.map