import { describe, it, expect } from "vitest";
import buildUuid from "../uuid";
describe("UUID Service", () => {
    it("should generate a UUID with eden prefix", () => {
        const uuid = buildUuid();
        expect(uuid).toMatch(/^eden-[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/);
    });
    it("should generate unique UUIDs", () => {
        const uuid1 = buildUuid();
        const uuid2 = buildUuid();
        expect(uuid1).not.toBe(uuid2);
    });
    it("should always start with eden-", () => {
        const uuid = buildUuid();
        expect(uuid.startsWith("eden-")).toBe(true);
    });
    it("should generate UUIDs of consistent length", () => {
        const uuid1 = buildUuid();
        const uuid2 = buildUuid();
        expect(uuid1.length).toBe(uuid2.length);
        expect(uuid1.length).toBe(41);
    });
});
