import { describe, it, expect } from "vitest";
import { noTrailingSlash } from "../check";
describe("Check Service", () => {
    describe("noTrailingSlash", () => {
        it("should return true for paths without trailing slash", () => {
            expect(noTrailingSlash("/about")).toBe(false);
            expect(noTrailingSlash("/contact")).toBe(false);
        });
        it("should return false for root path", () => {
            expect(noTrailingSlash("/")).toBe(true);
        });
        it("should return false for empty string", () => {
            expect(noTrailingSlash("")).toBe(true);
        });
        it("should return false for whitespace only", () => {
            expect(noTrailingSlash("   ")).toBe(true);
        });
        it("should return false for relative paths", () => {
            expect(noTrailingSlash("/path/to/page")).toBe(false);
        });
        it("should return true for protocol-relative URLs", () => {
            expect(noTrailingSlash("//example.com")).toBe(true);
        });
        it("should return true for absolute URLs", () => {
            expect(noTrailingSlash("https://example.com")).toBe(true);
            expect(noTrailingSlash("http://example.com")).toBe(true);
        });
        it("should return true for undefined", () => {
            expect(noTrailingSlash(undefined)).toBe(true);
        });
        it("should handle paths with special characters", () => {
            expect(noTrailingSlash("/path-with-dash")).toBe(false);
            expect(noTrailingSlash("/path_with_underscore")).toBe(false);
        });
        it("should handle deep paths", () => {
            expect(noTrailingSlash("/level1/level2/level3")).toBe(false);
        });
        it("should handle single character paths", () => {
            expect(noTrailingSlash("/a")).toBe(false);
        });
    });
});
