const userLanguage = window.navigator.language || "en";
let translations = {};
if (userLanguage.startsWith("fr")) {
    translations = await import("./fr.json");
}
else {
    translations = await import("./en.json");
}
export default function t(code, variables = {}) {
    const parts = code.split(".");
    let current = translations;
    for (const part of parts) {
        if (current && typeof current === "object" && part in current) {
            current = current[part];
        }
        else {
            return code;
        }
    }
    if (typeof current !== "string")
        return code;
    const template = current;
    const result = template.replace(/\$\s*\{([^}]+)\}/g, (_, key) => {
        return key in variables ? String(variables[key]) : "";
    });
    return result;
}
