import { describe, it, expect } from "vitest";
import t from "../index";
describe("i18n", () => {
    describe("translation function", () => {
        it("should return translation for existing key", () => {
            expect(t("common.remove")).toBe("Remove");
            expect(t("common.cancel")).toBe("Cancel");
        });
        it("should return nested translation", () => {
            expect(t("console.obsolete-block")).toBe("The block");
        });
        it("should return key if translation not found", () => {
            expect(t("nonexistent.key")).toBe("nonexistent.key");
        });
        it("should handle empty variables object", () => {
            const result = t("common.close", {});
            expect(result).toBe("Close");
        });
        it("should handle no variables parameter", () => {
            const result = t("common.save");
            expect(result).toBe("Save");
        });
        it("should handle variables in template", () => {
            const result = t("common.add");
            expect(typeof result).toBe("string");
        });
    });
    describe("edge cases", () => {
        it("should handle deeply nested keys", () => {
            const result = t("ui.add-block.categories.texts");
            expect(typeof result).toBe("string");
            expect(result.length).toBeGreaterThan(0);
            expect(result).not.toBe("ui.add-block.categories.texts");
        });
        it("should return code for invalid nested path", () => {
            expect(t("nested.nonexistent.deep")).toBe("nested.nonexistent.deep");
        });
        it("should handle empty string key", () => {
            expect(t("")).toBe("");
        });
        it("should handle key with only dots", () => {
            expect(t("...")).toBe("...");
        });
        it("should handle non-object nested values", () => {
            const result = t("common");
            expect(result).toBe("common");
        });
    });
});
