import Block from "./block.js";
import type Template from "./template.js";
import type EdenZoneUi from "../user-interface/zone/eden-zone-ui.js";
export default class Zone {
    element: HTMLElement;
    defaultContent?: string;
    maxBlocks?: number;
    templates?: string[];
    tagsLabel?: string;
    allowedTags?: string;
    allowMultipleTags?: boolean;
    isFixed?: boolean;
    isReadOnly?: boolean;
    withUuid?: boolean;
    hasChanged: boolean;
    defaultContentSpawned: boolean;
    templateDescriptors?: {
        [templateName: string]: Template;
    };
    blocks?: Block[];
    ui?: EdenZoneUi;
    constructor(element: HTMLElement, templateDescriptors: {
        [templateName: string]: Template;
    });
    analyse: () => Promise<void>;
    cleanRefs: () => void;
    showUi: () => Promise<void>;
    hideUi: () => void;
    activate: () => void;
    desactivate: () => void;
    preSave: () => void;
    postSave: () => void;
    displayInfo: () => void;
    hideInfo: () => void;
    addUuids: () => void;
    paste: () => Promise<void>;
    create: (code: string, variant?: string, showBlockUi?: boolean) => Promise<void>;
    createBlock: (templateCode: string, variant?: string, activateBlock?: boolean) => Promise<Block | undefined>;
    copy: () => Promise<void>;
    canAddBlock: () => boolean;
}
//# sourceMappingURL=zone.d.ts.map