import Template from "./template.js";
import type Zone from "./zone.js";
import type Brick from "./brick.js";
import type EdenSectionUi from "../user-interface/block/eden-block-ui.js";
import type EdenInfoUi from "../user-interface/block/eden-info-ui.js";
import type EdenHelper from "../user-interface/common/eden-helper.js";
import type { Action, ActionsGroup } from "../types.js";
export default class Block {
    element: HTMLElement;
    template?: Template;
    variant?: string;
    attributes?: {};
    obsolete?: true;
    zone?: Zone;
    code?: string;
    isCreation?: boolean;
    initialPosition?: CSSStyleDeclaration["position"];
    ui?: EdenSectionUi;
    infoUi?: EdenInfoUi;
    helper?: EdenHelper;
    instances?: Block[];
    activePlugins?: Brick[];
    actionsGroups?: ActionsGroup[];
    observer?: MutationObserver;
    contentHasChanged?: boolean;
    selectionIndicator?: HTMLElement;
    isLockedByRemotePlayer?: boolean;
    remoteContentUpdateHandler?: (event: Event) => void;
    remoteOperationHandler?: (event: Event) => void;
    remoteSelectionHandler?: (event: Event) => void;
    constructor(element: HTMLElement, template: Template, zone: Zone, code: string, isCreation: boolean);
    init: () => Promise<void> | undefined;
    setupRemoteEventListeners: () => void;
    handleRemoteContentUpdate: (event: Event) => Promise<void>;
    handleRemoteOperation: (event: Event) => Promise<void>;
    handleRemoteSelection: (event: Event) => Promise<void>;
    showRemoteSelectionIndicator: (selection: any) => Promise<void>;
    hideRemoteSelectionIndicator: () => void;
    activate: () => void;
    desactivate: () => void;
    cleanRefs: () => void;
    preSave: () => void;
    postSave: () => void;
    displayInfo: () => Promise<void>;
    hideInfo: () => void;
    create: (position: InsertPosition) => (code: string, variant?: string) => Promise<void>;
    createBefore: (code: string, variant?: string) => Promise<void>;
    createAfter: (code: string, variant?: string) => Promise<void>;
    remove: () => void;
    copy: (elementType: "zone" | "block", cutMode?: boolean) => Promise<void>;
    manualCopy: (elementType: "zone" | "block", cutMode?: boolean) => () => Promise<void>;
    copyZone: () => Promise<void>;
    copyBlock: () => Promise<void>;
    cutBlock: () => Promise<void>;
    copyDates: () => Promise<void>;
    setOrUpdateUuids: () => void;
    paste: (position: InsertPosition) => Promise<void>;
    manualPaste: (position: InsertPosition) => () => Promise<void>;
    pasteBefore: () => Promise<void>;
    pasteAfter: () => Promise<void>;
    duplicate: () => Promise<void>;
    selectDates: () => Promise<void>;
    settings: () => Promise<void>;
    changeSettings: ({ id, tags, variant, hidden, attributes, }: {
        id: string;
        tags: string;
        variant: string;
        hidden: boolean;
        attributes: {
            property: string;
            value: string;
        }[];
    }) => void;
    updateVariant: (variant?: string) => void;
    changeDates: (dates: string) => void;
    move: (position: InsertPosition) => () => void;
    moveBefore: () => void;
    moveAfter: () => void;
    showUi: (e?: Event) => Promise<void>;
    hideUi: () => void;
    addActions: (actionsGroups: ActionsGroup[]) => void;
    addToolbars: () => void;
    removeActions: (actionsGroups?: Action[][]) => void;
    manageActions: (pluginsToActivate: Brick[]) => Promise<void>;
    onClick: (e: MouseEvent) => Promise<void>;
    handleOutsideClick: (e: MouseEvent) => void;
    showHelper: (e: MouseEvent) => Promise<void>;
    hideHelper: () => void;
    onMouseEnter: () => void;
    onMouseLeave: () => void;
    onMouseMove: (e: MouseEvent) => void;
    handlePaste: (e: ClipboardEvent) => Promise<void>;
    isFirstChild: () => boolean;
    isLastChild: () => boolean;
    checkDates: () => void;
    cleanupDatesCheck: () => void;
}
export declare function pasteFromClipboard(position: InsertPosition, elementRef: HTMLElement): Promise<void>;
export declare function clipboardError(): void;
//# sourceMappingURL=block.d.ts.map