import Brick, { setEditable, unsetEditable } from "../core/brick.js";
import { getEmailPresenceHelperContent, textContainsEmail, } from "../services/email-in-text.js";
import { getTextLengthHerlperContent, preventDefaultIfNecessary, updateErrorAttribute, } from "../services/text-length.js";
export default class Text extends Brick {
    constructor({ block, element, parentBricks, options }) {
        super({ block, element, parentBricks });
        this.updateTextLengthHelper = (e) => {
            updateErrorAttribute(this.element, this.textLengthHelper, this.options);
            const helper = getTextLengthHerlperContent(this.element, this.options);
            if (!helper)
                return;
            const { content } = helper;
            this.textLengthHelper?.update(content);
            preventDefaultIfNecessary(e, Boolean(this.enforceTextLength), this.element, this.options);
        };
        this.spawnTextLengthHelper = async (e) => {
            const helper = getTextLengthHerlperContent(this.element, this.options);
            if (!helper)
                return;
            const { content, tooltip } = helper;
            const { default: EdenTextHelper } = await import("../user-interface/block/eden-text-helper.js");
            this.textLengthHelper = new EdenTextHelper({ content, tooltip });
            this.textLengthHelper.init();
            this.updateTextLengthHelper(e);
        };
        this.removeTextLengthHelper = () => {
            if (this.textLengthHelper) {
                this.textLengthHelper.remove();
            }
        };
        this.updateEmailPresenceHelper = () => {
            const content = getEmailPresenceHelperContent();
            this.emailPresenceHelper?.update(content);
        };
        this.spawnEmailPresenceHelper = async () => {
            const content = getEmailPresenceHelperContent();
            const { default: EdenTextHelper } = await import("../user-interface/block/eden-text-helper.js");
            this.emailPresenceHelper = new EdenTextHelper({ content });
            this.emailPresenceHelper.init();
            this.updateEmailPresenceHelper();
        };
        this.spawnOrUpdateEmailPresenceHelper = () => {
            const { allowClearTextEmail } = window.EdenConfig;
            const hasEmail = textContainsEmail(this.element);
            if (!allowClearTextEmail && hasEmail) {
                if (this.emailPresenceHelper) {
                    this.updateEmailPresenceHelper();
                }
                else {
                    this.spawnEmailPresenceHelper();
                }
            }
            else {
                this.removeEmailPresenceHelper();
            }
        };
        this.removeEmailPresenceHelper = () => {
            if (this.emailPresenceHelper) {
                this.emailPresenceHelper.remove();
                this.emailPresenceHelper = undefined;
            }
        };
        this.cleanupEmptyWithBr = () => {
            if (!this.element)
                return;
            const isEmpty = this.element.innerText.trim().length === 0;
            if (!isEmpty)
                return;
            const brs = Array.from(this.element.querySelectorAll("br"));
            if (brs.length > 1)
                return;
            brs.forEach((br) => br.remove());
        };
        this.options = options;
        this.hasTextLengthOption = this.options?.textLength?.max;
        this.textLengthHelper = undefined;
        this.actions = [];
    }
    activate() {
        if (this.element) {
            this.element.addEventListener("click", this.handleClick);
            setEditable(this.element);
            if (this.hasTextLengthOption) {
                this.element.addEventListener("input", this.updateTextLengthHelper);
                this.element.addEventListener("keydown", this.updateTextLengthHelper);
                this.element.addEventListener("click", this.updateTextLengthHelper);
                this.element.addEventListener("focus", this.spawnTextLengthHelper);
                this.element.addEventListener("blur", this.removeTextLengthHelper);
            }
            this.element.addEventListener("input", this.spawnOrUpdateEmailPresenceHelper);
            this.element.addEventListener("keydown", this.spawnOrUpdateEmailPresenceHelper);
            this.element.addEventListener("click", this.spawnOrUpdateEmailPresenceHelper);
            this.element.addEventListener("focus", this.spawnOrUpdateEmailPresenceHelper);
            this.element.addEventListener("blur", this.removeEmailPresenceHelper);
        }
    }
    desactivate() {
        if (this.element) {
            this.cleanupEmptyWithBr();
            unsetEditable(this.element);
            this.element.removeEventListener("click", this.handleClick);
            this.element.removeEventListener("blur", this.removeEmailPresenceHelper);
            this.element.removeEventListener("focus", this.spawnOrUpdateEmailPresenceHelper);
            this.element.removeEventListener("click", this.spawnOrUpdateEmailPresenceHelper);
            this.element.removeEventListener("keydown", this.spawnOrUpdateEmailPresenceHelper);
            this.element.removeEventListener("input", this.spawnOrUpdateEmailPresenceHelper);
            if (this.hasTextLengthOption) {
                this.element.removeEventListener("blur", this.removeTextLengthHelper);
                this.element.removeEventListener("focus", this.spawnTextLengthHelper);
                this.element.removeEventListener("click", this.updateTextLengthHelper);
                this.element.removeEventListener("keydown", this.updateTextLengthHelper);
                this.element.removeEventListener("input", this.updateTextLengthHelper);
            }
        }
    }
}
