import Brick from "../core/brick.js";
import type { BrickConstructor, TextOptions } from "../types.js";
import type EdenTextHelper from "../user-interface/block/eden-text-helper.js";
export default class Text extends Brick {
    options?: TextOptions;
    watchSelectionChange: boolean;
    hasTextLengthOption?: number;
    enforceTextLength?: boolean;
    textLengthHelper?: EdenTextHelper;
    emailPresenceHelper?: EdenTextHelper;
    constructor({ block, element, parentBricks, options }: BrickConstructor);
    updateTextLengthHelper: EventListener;
    spawnTextLengthHelper: EventListener;
    removeTextLengthHelper: () => void;
    updateEmailPresenceHelper: () => void;
    spawnEmailPresenceHelper: () => Promise<void>;
    spawnOrUpdateEmailPresenceHelper: () => void;
    removeEmailPresenceHelper: () => void;
    cleanupEmptyWithBr: () => void;
    activate(): void;
    desactivate(): void;
}
//# sourceMappingURL=Text.d.ts.map