import Brick from "../core/brick.js";
import GoogleMapsModal from "../user-interface/plugin/google-maps-modal.js";
import t from "../i18n/index.js";
export default class GoogleMaps extends Brick {
    constructor({ block, element, parentBricks }) {
        super({ block, element, parentBricks });
        this.openModal = () => {
            const iframe = this.element.querySelector("iframe");
            const url = iframe?.getAttribute("src") ?? "";
            const width = iframe?.getAttribute("width") ?? "1000";
            const height = iframe?.getAttribute("height") ?? "450";
            new GoogleMapsModal(this.updateUrl, url, width, height);
        };
        this.updateUrl = (url, width, height) => {
            const iframe = this.element.querySelector("iframe");
            if (iframe) {
                iframe.setAttribute("src", url);
                iframe.setAttribute("width", width);
                iframe.setAttribute("height", height);
            }
            else {
                this.createAndAppendIframe(url, width, height);
            }
        };
        this.mask = this.createMask();
        this.actions = [
            {
                tooltip: t("bricks.google-maps.modify-map"),
                icon: "map",
                action: this.openModal,
            },
        ];
    }
    createMask() {
        const mask = document.createElement("div");
        mask.style.cssText = `
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
    `;
        return mask;
    }
    createAndAppendIframe(url, width, height) {
        const newIframe = document.createElement("iframe");
        newIframe.src = url;
        newIframe.width = width;
        newIframe.height = height;
        newIframe.style.cssText = "max-width: 100%;";
        newIframe.setAttribute("frameborder", "0");
        newIframe.setAttribute("allowtransparency", "true");
        newIframe.setAttribute("allow", "encrypted-media");
        this.element.innerHTML = newIframe.outerHTML;
        this.element.appendChild(this.mask);
    }
    activate() {
        if (!this.element)
            return;
        this.element.addEventListener("click", this.handleClick);
        const iframe = this.element.querySelector("iframe");
        if (iframe) {
            this.element.style.position = "relative";
            this.element.appendChild(this.mask);
        }
    }
    desactivate() {
        if (!this.element)
            return;
        this.element.removeEventListener("click", this.handleClick);
        this.mask.remove();
        this.element.removeAttribute("style");
    }
}
